/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandGive;
import net.minecraft.command.CommandTime;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NPCSpawning;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.Util;

public class ServerEventsHandler {
    private final Map<Entity, List<AxisAlignedBB>> cacheAABB = new HashMap<Entity, List<AxisAlignedBB>>();
    private final List<EntityNPCInterface> cacheNPChb = new ArrayList<EntityNPCInterface>();
    private long currentTick = 0L;
    public static EntityVillager Merchant;
    public static Entity mounted;

    private void doFactionPoints(EntityPlayer player, EntityNPCInterface npc) {
        if (npc.advanced.factions.hasOptions()) {
            npc.advanced.factions.addPoints(player);
        } else {
            npc.faction.factions.addPoints(player);
        }
    }

    private void doKillQuest(EntityPlayer player, EntityLivingBase entity, boolean forAll) {
        PlayerData pdata = PlayerData.get(player);
        PlayerQuestData playerdata = pdata.questData;
        String entityName = EntityList.func_75621_b((Entity)entity);
        if (entity instanceof EntityPlayer) {
            entityName = "Player";
        }
        block0: for (QuestData data : new ArrayList<QuestData>(playerdata.activeQuests.values())) {
            if (data.quest.step == 2 && data.quest.questInterface.isCompleted(player)) continue;
            boolean bo = data.quest.step == 1;
            for (IQuestObjective obj : data.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                HashMap<String, Integer> killed;
                if (data.quest.step == 1 && !bo) continue block0;
                bo = obj.isCompleted();
                if (((QuestObjective)obj).getEnumType() != EnumQuestTask.KILL && ((QuestObjective)obj).getEnumType() != EnumQuestTask.AREAKILL) continue;
                String name = null;
                if (obj.getTargetName().equals(entity.func_70005_c_())) {
                    name = entity.func_70005_c_();
                } else if (obj.getTargetName().equals(entityName)) {
                    name = entityName;
                } else {
                    if (!obj.isPartName() && !obj.isAndTitle()) continue;
                    if (obj.isPartName()) {
                        if (entity.func_70005_c_().contains(obj.getTargetName())) {
                            name = obj.getTargetName();
                        } else {
                            assert (entityName != null);
                            if (entityName.contains(obj.getTargetName())) {
                                name = obj.getTargetName();
                            }
                        }
                    }
                    if (name == null && obj.isAndTitle() && entity instanceof EntityNPCInterface) {
                        EntityNPCInterface npc = (EntityNPCInterface)entity;
                        String title = npc.display.getTitle();
                        if (title.equals(obj.getTargetName())) {
                            name = entity.func_70005_c_();
                        } else if (title.equals(entityName)) {
                            name = entityName;
                        }
                        if (name == null && obj.isPartName()) {
                            if (title.contains(obj.getTargetName())) {
                                name = obj.getTargetName();
                            } else if (title.contains(obj.getTargetName())) {
                                name = obj.getTargetName();
                            }
                        }
                    }
                }
                if (name == null) continue;
                if (obj.getType() == EnumQuestTask.AREAKILL.ordinal() && forAll) {
                    for (EntityPlayer pl : Util.instance.getEntitiesWithinDist(EntityPlayer.class, player.field_70170_p, (Entity)player, (double)obj.getAreaRange())) {
                        if (pl == player) continue;
                        this.doKillQuest(pl, entity, false);
                    }
                }
                if ((killed = ((QuestObjective)obj).getKilled(data)).containsKey(name) && killed.get(name) >= obj.getMaxProgress()) continue;
                int amount = 0;
                if (killed.containsKey(name)) {
                    amount = killed.get(name);
                }
                killed.put(name, ++amount);
                ((QuestObjective)obj).setKilled(data, killed);
                if (data.quest.showProgressInWindow) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74768_a("QuestID", data.quest.id);
                    compound.func_74778_a("Type", "kill");
                    compound.func_74783_a("Progress", new int[]{amount, obj.getMaxProgress()});
                    compound.func_74778_a("TargetName", new TextComponentTranslation("script.killed", new Object[0]).func_150254_d() + ": \"" + entity.func_70005_c_() + "\"");
                    compound.func_74768_a("MessageType", 0);
                    Server.sendData((EntityPlayerMP)player, EnumPacketClient.MESSAGE_DATA, compound);
                }
                if (data.quest.showProgressInChat) {
                    if (amount >= obj.getMaxProgress()) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.kill.1", new Object[]{new TextComponentTranslation(entity.func_70005_c_(), new Object[0]).func_150254_d(), data.quest.getTitle()}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.kill.0", new Object[]{new TextComponentTranslation(entity.func_70005_c_(), new Object[0]).func_150254_d(), "" + amount, "" + obj.getMaxProgress(), data.quest.getTitle()}));
                    }
                }
                playerdata.checkQuestCompletion(player, data);
                playerdata.updateClient = true;
            }
        }
    }

    @SubscribeEvent
    public void npcCommands(CommandEvent event) {
        CustomNpcs.debugData.start(event.getSender());
        if (event.getSender() instanceof EntityPlayer) {
            PlayerEvent.CommandEvent ev = new PlayerEvent.CommandEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)event.getSender()), event.getCommand(), event.getParameters());
            EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)((EntityPlayer)event.getSender())).scriptData, EnumScriptType.SEND_COMMAND, (Event)ev);
            if (ev.isCanceled()) {
                event.setCanceled(true);
                CustomNpcs.debugData.end(event.getSender());
                return;
            }
        }
        if (event.getCommand() instanceof CommandGive) {
            if (!(event.getSender().func_130014_f_() instanceof WorldServer)) {
                CustomNpcs.debugData.end(event.getSender());
                return;
            }
            try {
                EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)Objects.requireNonNull(event.getSender().func_184102_h()), (ICommandSender)event.getSender(), (String)event.getParameters()[0]);
                Objects.requireNonNull(player.func_184102_h()).field_175589_i.add(ListenableFutureTask.create(Executors.callable(() -> ServerEventsHandler.lambda$npcCommands$0((EntityPlayer)player))));
            }
            catch (Exception e) {
                LogWriter.error("Error player check quest completion:", e);
            }
        } else if (event.getCommand() instanceof CommandTime) {
            try {
                List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                for (EntityPlayerMP playerMP : players) {
                    CustomNpcs.visibilityController.onUpdate(playerMP);
                }
            }
            catch (Exception e) {
                LogWriter.error("Error player update visible NPC:", e);
            }
        }
        CustomNpcs.debugData.end(event.getSender());
    }

    @SubscribeEvent
    public void npcDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityLiving());
        Entity source = NoppesUtilServer.GetDamageSource(event.getSource());
        if (source != null) {
            if (source instanceof EntityNPCInterface && event.getEntityLiving() != null) {
                EntityNPCInterface npc = (EntityNPCInterface)source;
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(Line.formatTarget(line, event.getEntityLiving()));
                }
                EventHooks.onNPCKills(npc, event.getEntityLiving());
            }
            EntityPlayer player = null;
            if (source instanceof EntityPlayer) {
                player = (EntityPlayer)source;
            } else if (source instanceof EntityNPCInterface && ((EntityNPCInterface)source).getOwner() instanceof EntityPlayer) {
                player = (EntityPlayer)((EntityNPCInterface)source).getOwner();
            }
            if (player != null) {
                this.doKillQuest(player, event.getEntityLiving(), true);
                if (event.getEntityLiving() instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)event.getEntityLiving());
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            PlayerData data = PlayerData.get((EntityPlayer)event.getEntityLiving());
            data.save(false);
        }
        CustomNpcs.debugData.end(event.getEntityLiving());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void npcEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        CustomNpcs.debugData.start(event.getObject());
        if (event.getObject() instanceof EntityPlayer) {
            PlayerData.register(event);
        }
        if (event.getObject() instanceof EntityLivingBase) {
            MarkData.register(event);
        }
        if (((Entity)event.getObject()).field_70170_p != null) {
            try {
                WrapperEntityData.register(event);
            }
            catch (Exception e) {
                LogWriter.error("Error register wrapper entity:", e);
            }
        }
        CustomNpcs.debugData.end(event.getObject());
    }

    @SubscribeEvent
    public void npcEntityJoin(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntity());
        PlayerData data = PlayerData.get((EntityPlayer)event.getEntity());
        data.updateCompanion(event.getWorld());
        CustomNpcs.debugData.end(event.getEntity());
    }

    @SubscribeEvent
    public void npcItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof UniversalBucket) {
            return;
        }
        CustomNpcs.debugData.start("Item");
        ItemStackWrapper.register(event);
        CustomNpcs.debugData.end("Item");
    }

    @SubscribeEvent
    public void npcPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        CustomNpcs.debugData.start(event.getEntityPlayer());
        ItemStack item = event.getEntityPlayer().func_184614_ca();
        boolean isClient = event.getEntityPlayer().field_70170_p.field_72995_K;
        boolean npcInteracted = event.getTarget() instanceof EntityNPCInterface;
        if (!isClient && CustomNpcs.OpsOnly && !Objects.requireNonNull(event.getEntityPlayer().func_184102_h()).func_184103_al().func_152596_g(event.getEntityPlayer().func_146103_bH())) {
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        if (!isClient && item.func_77973_b() == CustomRegisters.soulstoneEmpty && event.getTarget() instanceof EntityLivingBase) {
            ((ItemSoulstoneEmpty)item.func_77973_b()).store((EntityLivingBase)event.getTarget(), item, event.getEntityPlayer());
        }
        if (item.func_77973_b() == CustomRegisters.wand && npcInteracted && !isClient) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.NPC_GUI)) {
                CustomNpcs.debugData.end(event.getEntityPlayer());
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.getEntityPlayer(), EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.getTarget());
        } else if (item.func_77973_b() == CustomRegisters.cloner && !isClient && !(event.getTarget() instanceof EntityPlayer)) {
            NBTTagCompound compound = new NBTTagCompound();
            if (!event.getTarget().func_184198_c(compound)) {
                CustomNpcs.debugData.end(event.getEntityPlayer());
                return;
            }
            String s = compound.func_74779_i("id");
            if (s.equals("minecraft:customnpcs.customnpc") || s.equals("minecraft:customnpcs:customnpc")) {
                compound.func_74778_a("id", "customnpcs:customnpc");
            }
            PlayerData data = PlayerData.get(event.getEntityPlayer());
            ServerCloneController.Instance.cleanTags(compound);
            if (!Server.sendDataChecked((EntityPlayerMP)event.getEntityPlayer(), EnumPacketClient.CLONE, compound)) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Entity too big to clone"));
            }
            data.cloned = compound;
            event.setCanceled(true);
        } else if (item.func_77973_b() == CustomRegisters.scripter && !isClient && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.NPC_GUI)) {
                CustomNpcs.debugData.end(event.getEntityPlayer());
                return;
            }
            NoppesUtilServer.setEditingNpc(event.getEntityPlayer(), (EntityNPCInterface)event.getTarget());
            event.setCanceled(true);
            Server.sendData((EntityPlayerMP)event.getEntityPlayer(), EnumPacketClient.GUI, EnumGuiType.Script.ordinal(), 0, 0, 0);
        } else if (item.func_77973_b() == CustomRegisters.mount) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.TOOL_MOUNTER)) {
                CustomNpcs.debugData.end(event.getEntityPlayer());
                return;
            }
            event.setCanceled(true);
            mounted = event.getTarget();
            if (isClient) {
                CustomNpcs.proxy.openGui(MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70165_t), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70163_u), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70161_v), EnumGuiType.MobSpawnerMounter, event.getEntityPlayer());
            }
        } else if (item.func_77973_b() == CustomRegisters.wand && event.getTarget() instanceof EntityVillager) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.EDIT_VILLAGER)) {
                CustomNpcs.debugData.end(event.getEntityPlayer());
                return;
            }
            event.setCanceled(true);
            Merchant = (EntityVillager)event.getTarget();
            if (!isClient) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.MerchantAdd.ordinal(), player.field_70170_p, 0, 0, 0);
                MerchantRecipeList merchantrecipelist = Merchant.func_70934_b((EntityPlayer)player);
                if (merchantrecipelist != null) {
                    Server.sendData(player, EnumPacketClient.VILLAGER_LIST, merchantrecipelist);
                }
            }
        }
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPlayerTracking(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof EntityLivingBase) || event.getTarget().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        if (event.getTarget() instanceof EntityNPCInterface && CustomNpcs.EnableInvisibleNpcs) {
            CustomNpcs.visibilityController.checkIsVisible((EntityNPCInterface)event.getTarget(), (EntityPlayerMP)event.getEntityPlayer());
        }
        MarkData data = MarkData.get((EntityLivingBase)event.getTarget());
        if (data.marks.isEmpty()) {
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        Server.sendData((EntityPlayerMP)event.getEntityPlayer(), EnumPacketClient.MARK_DATA, event.getTarget().func_145782_y(), data.getNBT());
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPopulateChunk(PopulateChunkEvent.Post event) {
        if (!(event.getWorld() instanceof WorldServer)) {
            return;
        }
        CustomNpcs.debugData.start(null);
        NPCSpawning.performWorldGenSpawning((WorldServer)event.getWorld(), event.getChunkX(), event.getChunkZ(), event.getRand());
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcSaveChunk(ChunkDataEvent.Save event) {
        CustomNpcs.debugData.start(null);
        for (ClassInheritanceMultiMap map : event.getChunk().func_177429_s()) {
            for (Entity e : map) {
                if (!(e instanceof EntityLivingBase)) continue;
                MarkData md = MarkData.get((EntityLivingBase)e);
                if (md.entity == null) {
                    md.entity = (EntityLivingBase)e;
                }
                md.save();
            }
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcSavePlayer(PlayerEvent.SaveToFile event) {
        CustomNpcs.debugData.start(event.getEntityPlayer());
        PlayerData.get(event.getEntityPlayer()).save(false);
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcWorldUnload(WorldEvent.Unload event) {
        CustomNpcs.debugData.start(null);
        int dimensionID = event.getWorld().field_73011_w.getDimension();
        if (!event.getWorld().field_72995_K) {
            DimensionHandler.getInstance().unload(event.getWorld(), dimensionID);
        }
        CustomNpcs.debugData.end(null);
    }

    @SubscribeEvent
    public void npcGetCollisionBoxes(GetCollisionBoxesEvent event) {
        long tick;
        Entity entity = event.getEntity();
        if (entity == null || entity.field_70170_p == null) {
            return;
        }
        CustomNpcs.debugData.start(entity);
        if (entity.field_70170_p.field_72995_K) {
            tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        } else {
            if (entity.func_184102_h() == null) {
                return;
            }
            tick = entity.func_184102_h().func_71218_a(0).func_82737_E();
        }
        if (tick != this.currentTick) {
            this.cacheAABB.clear();
            this.cacheNPChb.clear();
            this.currentTick = tick;
        }
        if (this.cacheAABB.containsKey(entity)) {
            event.getCollisionBoxesList().addAll((Collection)this.cacheAABB.get(entity));
        } else {
            if (this.cacheNPChb.isEmpty()) {
                for (Entity e : new ArrayList(entity.field_70170_p.field_72996_f)) {
                    if (!(e instanceof EntityNPCInterface) || ((EntityNPCInterface)e).display.getHitboxState() != 2) continue;
                    this.cacheNPChb.add((EntityNPCInterface)e);
                }
            }
            for (EntityNPCInterface npc : new ArrayList<EntityNPCInterface>(this.cacheNPChb)) {
                if (npc == null || npc.isKilled()) continue;
                List<AxisAlignedBB> list = this.cacheAABB.get(entity);
                if (list == null) {
                    list = new ArrayList<AxisAlignedBB>();
                }
                try {
                    double dist;
                    if (npc == entity || (dist = npc.func_70068_e(entity)) > 450.0) continue;
                    AxisAlignedBB aabb = npc.func_174813_aQ();
                    if (!event.getAabb().func_72326_a(aabb)) continue;
                    if (!npc.func_70661_as().func_75500_f()) {
                        aabb = aabb.func_72314_b((double)npc.field_70130_N * 0.25, 0.0, (double)npc.field_70130_N * 0.25);
                    }
                    list.add(aabb);
                    event.getCollisionBoxesList().add(aabb);
                    npc.addRidingEntity(entity);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                this.cacheAABB.put(entity, list);
            }
        }
        CustomNpcs.debugData.end(entity);
    }

    private static /* synthetic */ void lambda$npcCommands$0(EntityPlayer player) {
        PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
        for (QuestData data : playerdata.activeQuests.values()) {
            for (QuestObjective obj : data.quest.getObjectives(player)) {
                if (obj.getType() != EnumQuestTask.ITEM.ordinal()) continue;
                playerdata.checkQuestCompletion(player, data);
                playerdata.updateClient = true;
            }
        }
    }
}

